package csbase.client.facilities.configurabletable.UI;

/**
 * Enumerao que define se as tabelas estaro dispostas horizontalmente ou
 * verticalmente no painel/aba.
 * 
 * @see Panel4Tables TabbedPane4Tables
 * 
 * @author Tecgraf
 */
public enum ORIENTATION {

  /** Orientao horizontal */
  HORIZONTAL,

  /** Orientao horizontal */
  Horizontal,

  /** Orientao horizontal */
  horizontal,

  /** Orientao vertical */
  VERTICAL,

  /** Orientao horizontal */
  Vertical,

  /** Orientao horizontal */
  vertical;

  /**
   * Obtm a constante de orientao correspondente ao <code>value</code>. Caso
   * o valor passado no seja equivalente a nenhuma das constantes, por padro,
   * retornamos a constante de orientao vertical.
   * 
   * @param value - valor da orientao.
   * @return constante de orientao correspondente.
   */
  static public ORIENTATION value(String value) {
    ORIENTATION result = VERTICAL;

    if (value != null) {
      try {
        result = valueOf(value);
      }
      catch (IllegalArgumentException e) {
        result = VERTICAL;
      }
    }

    return result;
  }

}
