package csbase.client.facilities.configurabletable.UI;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JSplitPane;

import csbase.client.facilities.configurabletable.table.ConfigurableTable;

/**
 * Painel com separador especializado em exibir tabelas configurveis.
 * 
 * @author Tecgraf
 */
public class SplitPane4Tables extends JSplitPane implements UI4Tables {

  /**
   * Identificador do painel com separador.
   */
  private String id;

  /**
   * Paineis que contm as tabelas.
   */
  private List<Panel4Tables> panels;

  /**
   * Construtor padro.
   * 
   * @param id - identificador do painel com separador.
   * @param orientation - orientao do painel.
   */
  public SplitPane4Tables(String id, ORIENTATION orientation) {
    super(convertOrientation(orientation));

    if (id == null) {
      throw new IllegalArgumentException("id no pode ser nulo.");
    }

    if (orientation == null) {
      throw new IllegalArgumentException("orientation no pode ser nulo.");
    }

    this.id = id;
    this.panels = new ArrayList<Panel4Tables>();
  }

  /**
   * Converte enumerao de orientao para a orientao usada pelo
   * {@link JSplitPane}.
   * 
   * @param orientation - enumerao.
   * @return valor inteiro da orientao do {@link JSplitPane}.
   */
  static int convertOrientation(ORIENTATION orientation) {
    int orientationInt = JSplitPane.VERTICAL_SPLIT;
    if (orientation == ORIENTATION.horizontal
      || orientation == ORIENTATION.Horizontal
      || orientation == ORIENTATION.HORIZONTAL) {

      orientationInt = JSplitPane.HORIZONTAL_SPLIT;

    }
    return orientationInt;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * Adiciona uma tabela no painel com separador.
   * 
   * @param <T> - tipo dos dados exibidos na tabela.
   * @param table - tabela a ser adicionada.
   * @param label - rtulo da tabela.
   * @param dataType - tipo dos dados exibidos na tabela.
   */
  public <T> void addTable(ConfigurableTable<?> table, String label,
    Class<T> dataType) {

    // permitir apenas dois elementos na lista
    if (panels.size() == 2) {
      throw new RuntimeException("SplitPane4Tables s permite 2 tabelas.");
    }

    Panel4Tables panel = new Panel4Tables(getId(), ORIENTATION.horizontal);
    panel.addTable(table, label, dataType);

    panels.add(panel);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ConfigurableTable<?>> getAllTables() {
    List<ConfigurableTable<?>> allTables =
      new ArrayList<ConfigurableTable<?>>();

    for (Panel4Tables panel : panels) {
      allTables.addAll(panel.getAllTables());
    }

    return allTables;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public <T> List<ConfigurableTable<T>> getAllTables(Class<T> dataType) {
    List<ConfigurableTable<T>> allTables =
      new ArrayList<ConfigurableTable<T>>();

    for (Panel4Tables panel : panels) {
      allTables.addAll(panel.getAllTables(dataType));
    }

    return allTables;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConfigurableTable<?> getTableById(String tableId) {
    for (Panel4Tables panel : panels) {
      ConfigurableTable<?> table = panel.getTableById(tableId);
      if (table != null) {
        return table;
      }
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public <T> ConfigurableTable<T> getTableById(String tableId, Class<T> dataType) {
    for (Panel4Tables panel : panels) {
      ConfigurableTable<T> table = panel.getTableById(tableId, dataType);
      if (table != null) {
        return table;
      }
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ConfigurableTable<?>> getTablesFromSelectedComponent() {
    return getAllTables();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public <T> List<ConfigurableTable<T>> getTablesFromSelectedComponent(
    Class<T> dataType) {
    return getAllTables(dataType);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getTableLabel(String tableId) {
    for (Panel4Tables panel : panels) {
      String result = panel.getTableLabel(tableId);
      if (result != null) {
        return result;
      }
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void buildUI() {
    setOneTouchExpandable(true);

    // permitir apenas dois elementos na lista
    if (panels.size() != 2) {
      throw new RuntimeException("SplitPane4Tables s permite 2 tabelas.");
    }

    for (Panel4Tables panel : panels) {
      panel.buildUI();
      add(panel);
    }
  }

}
