/*
 * $Id: DynamicMonitorPanel.java 157822 2014-10-30 13:25:28Z pietroguedes $
 */
package csbase.client.facilities.monitoring;

import javax.swing.JPanel;

/**
 * A classe <code>DynamicMonitorPanel</code> modela a funcionalidade comum a
 * todos os painis dinmicos de monitorao.
 * 
 * @author Tecgraf/PUC-Rio.
 */
public abstract class DynamicMonitorPanel extends JPanel {
  /**
   * Atualiza os dados.
   * 
   * @param dynamicData os dados dinmicos
   */
  public abstract void updateDynamicInfo(Object dynamicData);

  /**
   * Consulta o ttulo.
   * 
   * @return o ttulo
   */
  public abstract String getTitle();

  /**
   * Construtor
   */
  public DynamicMonitorPanel() {
    super();
  }
}
