package csbase.client.ias;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Role;
import csbase.logic.User;

/**
 * Janela que associa usurios a um perfil.
 * 
 * @author Tecgraf
 */
public final class RoleUserDefinitionDialog {

  private JFrame owner;
  private String dialogTitle;
  private DesktopComponentDialog mainDialog;
  private Container cp;
  private boolean wasChanged;
  private ContainerSelection<User> usersSelection;
  private JButton actionButton;
  private Role role;

  public RoleUserDefinitionDialog(JFrame owner) {

    this.owner = owner;
    dialogTitle = LNG.get("IAS_ROLE_USERS_TITLE");
    mainDialog = new DesktopComponentDialog(this.owner, this.dialogTitle);
    cp = mainDialog.getContentPane();

    this.wasChanged = false;
  }

  public void showDialog(Role role) {

    this.role = role;

    Vector<User> users = getUsers();
    Vector<User> selectedUsers = getSelectedUsers(users);

    JPanel selectionPanel = createSelectionPanel(users, selectedUsers);
    cp.add(selectionPanel, BorderLayout.CENTER);
    this.wasChanged = false;

    createActionButton();
    JButton closeButton = createCloseButton();
    ClientUtilities.adjustEqualSizes(actionButton, closeButton);

    JPanel buttonsPanel = new JPanel();
    buttonsPanel.add(actionButton);
    buttonsPanel.add(closeButton);

    cp.add(buttonsPanel, BorderLayout.SOUTH);

    mainDialog.pack();
    mainDialog.center(owner);
    mainDialog.setVisible(true);
  }

  private JButton createCloseButton() {
    JButton closeButton = new JButton(LNG.get("IAS_CLOSE"));
    closeButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        if (wasChanged) {
          Object[] options =
            { LNG.get("IAS_ROLE_UPDATE"), LNG.get("IAS_CANCEL") };
          int selected =
            JOptionPane.showOptionDialog(mainDialog,
              LNG.get("IAS_ROLE_UPDATE_QUESTION"), dialogTitle,
              JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
              null, options, options[0]);
          if (options[selected] == LNG.get("IAS_ROLE_UPDATE")) {
            updateRolesUserList();
          }
        }

        mainDialog.close();
      }
    });
    return closeButton;
  }

  private void createActionButton() {
    actionButton = new JButton(LNG.get("IAS_ROLE_UPDATE"));
    actionButton.setEnabled(false);
    actionButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        updateRolesUserList();
        mainDialog.close();
      }
    });
  }

  private Vector<User> getUsers() {
    Vector<User> users = null;
    users =
      UserProxy.getAllUsers(mainDialog, dialogTitle, LNG.get("ERRO") + " - "
        + dialogTitle);

    Iterator<User> userIterator = users.iterator();
    while (userIterator.hasNext()) {
      User user = userIterator.next();
      if (user.getId().equals(User.getAdminId())) {
        users.remove(user);
        break;
      }
    }

    return users;
  }

  private Vector<User> getSelectedUsers(Vector users) {
    Vector<User> selectedUsers = new Vector<User>();
    Iterator<User> userIterator = users.iterator();
    while (userIterator.hasNext()) {
      User user = userIterator.next();
      if (user.getRole(this.role.getId()) != null) {
        selectedUsers.add(user);
      }
    }
    return selectedUsers;
  }

  private JPanel createSelectionPanel(Vector<User> selectableUsers,
    Vector<User> selectedUsers) {
    ObjectTableProvider selectableFormat = new DefaultObjectTableProvider() {
      /**
       * {@inheritDoc}
       */
      @Override
      public Object[] getCellValues(Object item) {
        User user = (User) item;
        return (user == null) ? null : new String[] { user.getId().toString(),
            user.getName() };
      }

      /**
       * {@inheritDoc}
       */
      @Override
      public String[] getColumnNames() {
        return new String[] { LNG.get("IAS_USERS_KEY"),
            LNG.get("IAS_AVAILABLE_USERS") };
      }

      /**
       * {@inheritDoc}
       */
      @Override
      public Class<?>[] getColumnClasses() {
        return new Class<?>[] { String.class, String.class };
      }
    };
    ObjectTableProvider selectedFormat = new DefaultObjectTableProvider() {
      /**
       * {@inheritDoc}
       */
      @Override
      public Object[] getCellValues(Object item) {
        User user = (User) item;
        return (user == null) ? null : new String[] { user.getId().toString(),
            user.getName() };
      }

      /**
       * {@inheritDoc}
       */
      @Override
      public String[] getColumnNames() {
        return new String[] { LNG.get("IAS_USERS_KEY"),
            LNG.get("IAS_SELECTED_USERS") };
      }

      /**
       * {@inheritDoc}
       */
      @Override
      public Class<?>[] getColumnClasses() {
        return new Class<?>[] { String.class, String.class };
      }
    };
    usersSelection =
      new ContainerSelection<User>(selectableFormat, selectedFormat, true,
        false);
    usersSelection.loadItems(selectableUsers, selectedUsers);
    usersSelection.adjustTableColumns();
    usersSelection
      .addContainerSelectionListener(new ContainerSelectionListener() {
        @Override
        public void containerChanged() {
          wasChanged = true;
          actionButton.setEnabled(true);
        }
      });
    return usersSelection.getPanel();
  }

  private void updateRolesUserList() {

    boolean success = true;

    try {

      List<User> usersAvailable = usersSelection.getAvailableItems();
      for (User user : usersAvailable) {
        user.removeRole(role);
      }
      UserProxy.modifyUsers(owner, dialogTitle,
        LNG.get("IAS_WAITING_USER_MODIFICATION"), usersAvailable);

      List<User> usersSelected = usersSelection.getSelectedItems();
      for (User user : usersSelected) {
        user.addRole(role);
      }
      UserProxy.modifyUsers(owner, dialogTitle,
        LNG.get("IAS_WAITING_USER_MODIFICATION"), usersSelected);

      String msg =
        LNG.get(success ? "IAS_ROLE_UPDATED_WITH_SUCCESS"
          : "IAS_ROLE_UPDATED_WITH_ERROR");
      StandardDialogs.showInfoDialog(mainDialog, dialogTitle, msg);

      wasChanged = false;
    }
    catch (Exception e) {
      success = false;
      StandardErrorDialogs.showErrorDialog(owner, LNG.get("ERRO") + " - "
        + dialogTitle, e);
    }
  }
}
