package csbase.client.ias;

import csbase.logic.UserGroup;

/**
 * Wrapper de grupos de usurios para facilitar a exibio. So esses Wrappers
 * os objetos listados na ComboBox de grupos de usurios usada nas subclasses de
 * {@link csbase.client.ias.UserInfoDialog}.
 */
class UserGroupName {
  private UserGroup userGroup;

  /**
   * Cria um Wrapper de grupo de usurio
   * 
   * @param userGroup o grupo de usurio encapsulado pelo Wrapper.
   */
  public UserGroupName(UserGroup userGroup) {
    this.userGroup = userGroup;
  }

  /**
   * Obtm uma representao textual do grupo de usurio.
   * 
   * @return representao textual do grupo de usurio.
   */
  @Override
  public String toString() {
    if ((userGroup == null) || (userGroup.getName() == null)) {
      return "";
    }
    return userGroup.getName();
  }

  /**
   * Obtm o grupo de usurio englobado pelo Wrapper.
   * 
   * @return o grupo de usurio englobado pelo Wrapper.
   */
  public UserGroup getUserGroup() {
    return userGroup;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object o) {
    if (o instanceof UserGroupName) {
      UserGroupName another = (UserGroupName) o;
      if ((userGroup == null) || (another.userGroup == null)) {
        return false;
      }
      return another.userGroup.getName().equals(userGroup.getName());
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    if (userGroup == null) {
      return "userGroup attribute is null".hashCode();
    }

    return userGroup.getName().hashCode();
  }
}
