package csbase.client.login;

import java.util.Locale;

/**
 * Representa um item pertencente  uma combo box de locales.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class LocaleComboBoxItem {

  /**
   * O nome do item.
   */
  private String name;

  /**
   * O locale representado pelo item.
   */
  private Locale locale;

  /**
   * Cria um item de combo box de locale.
   * 
   * @param name O nome do item.
   * @param locale O locale representado pelo item.
   * 
   * @throws IllegalArgumentException Caso o nome ou o locale sejam nulos.
   */
  LocaleComboBoxItem(String name, Locale locale) {
    if (name == null) {
      throw new IllegalArgumentException(
        "O nome do item de ComboBox de locales no pode ser nulo.");
    }
    if (locale == null) {
      throw new IllegalArgumentException(
        "O locale do item de ComboBox de locales no pode ser nulo.");
    }
    this.name = name;
    this.locale = locale;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return this.name;
  }

  /**
   * Obtm o locale representado pelo item.
   * 
   * @return O locale representado pelo item.
   */
  public Locale getLocale() {
    return this.locale;
  }

  /**
   * Consulta o valor de name
   * 
   * @return o valor
   */
  public final String getName() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    final int PRIME = 31;
    int result = 1;
    result =
      PRIME * result + ((this.locale == null) ? 0 : this.locale.hashCode());
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    final LocaleComboBoxItem other = (LocaleComboBoxItem) obj;
    if (this.locale == null) {
      if (other.locale != null)
        return false;
    }
    else if (!this.locale.equals(other.locale))
      return false;
    return true;
  }
}
