/*
 * $Id$
 */
package csbase.client.login;

import java.util.Locale;

/**
 * Interface para padronizar o processo de login
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface LoginInterface {

  /**
   * Inicia o processo de login
   * 
   * @param defaultLocale Locale utilizado
   * @param systemName Nome do sistema
   * @return o contexto
   */
  public InitialContext login(Locale defaultLocale, String systemName);

  /**
   * Notifica da inicializao da interface do cliente
   */
  public void notifyPreInitialization();

  /**
   * Notifica inicializao concluda da interface do cliente
   */
  public void notifyInitialized();

  /**
   * Notifica erro durante carga da interface do cliente
   * 
   * @param e Exceo lanada
   */
  public void notifyException(Exception e);

  /**
   * Retorna um identificador da instncia para o cliente
   * 
   * @return o id do cliente corrente
   */
  public String getClientInstanceId();

  /**
   * Retorna um identificador da instncia-cliente que originou a execuo deste
   * cliente
   * 
   * @return o id do cliente originrio.
   */
  public String getFatherClientInstanceId();

}
