/**
 * $Id$
 */
package csbase.client.openbus;

import java.util.Locale;

import org.apache.commons.codec.binary.Base64;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.Client;
import csbase.client.login.InitialContext;
import csbase.client.login.LoginInterface;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.logic.url.URLParameters;

/**
 * Executa o procedimento de login atravs de uma credencial do OpenBus.
 *
 * @author Tecvraf/PUC-Rio
 */
public final class OpenBusLogin implements LoginInterface {

  /**
   * O contexto inicial de execuo do cliente.
   */
  private InitialContext context;
  /**
   * O tonken para autenticao no barramento.
   */
  private OpenBusLoginToken token;

  /**
   * Cria o objeto responsvel por logar o usurio atravs de uma credencial do
   * OpenBus.
   *
   * @param context O contexto inicial de execuo do cliente.
   */
  public OpenBusLogin(InitialContext context) {
    this.context = context;
    final Client client = Client.getInstance();
    String user =
      client.getParameter(URLParameters.OPENBUS_TOKEN_USER_PARAMETER);
    byte[] secret =
      Base64.decodeBase64(client
        .getParameter(URLParameters.OPENBUS_TOKEN_SECRET_PARAMETER));

    this.token = new OpenBusLoginToken(user, secret);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public InitialContext login(Locale defaultLocale, String systemName) {
    ClientRemoteMonitor.getInstance().getServerLookupThread().start();

    try {
      ClientRemoteMonitor.getInstance().start(this.token, defaultLocale);
      if (!ClientRemoteMonitor.getInstance().isAlive()) {
        StandardDialogs.showErrorDialog(null, systemName,
          "Login ou senha invlidos.");
        return null;
      }
    }
    catch (CSBaseException e) {
      StandardDialogs
      .showErrorDialog(
        null,
        systemName,
        "No foi possvel acessar o servidor. Provavelmente o servidor est fora do ar.");
      e.printStackTrace();
      return null;
    }

    return this.context;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyException(Exception e) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyInitialized() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyPreInitialization() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClientInstanceId() {
    final Client client = Client.getInstance();
    final String paramName = URLParameters.CURRENT_CLIENT_IDENTIFIER_PARAMETER;
    final String id = client.getParameter(paramName);
    return id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getFatherClientInstanceId() {
    final Client client = Client.getInstance();
    final String paramName = URLParameters.SOURCE_CLIENT_IDENTIFIER_PARAMETER;
    final String id = client.getParameter(paramName);
    return id;
  }
}
