package csbase.client.preferences.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.definition.PreferenceDefinition;

/**
 * Anotao que define qual classe que encapsula o editor de uma preferncia.
 * Atualmente, cada valor de preferncia define seu editor default. Porm, h
 * diversos casos em que queremos sobrescrever este editor para uma UI mais
 * intuitiva e especializada.
 * 
 * @see PreferenceDefinition PreferenceValue
 * 
 * @author Tecgraf
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Editor {

  /**
   * Classe que encapsula o editor da preferncia.
   * 
   * @return classe que encapsula o editor da preferncia.
   */
  Class<? extends PreferenceEditor<?>> value();
}
