package csbase.client.preferences.editors;

import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Classe que encapsula a edio de um {@link String}.
 * 
 * @author Tecgraf
 */
public class PVStringEditor extends PreferenceEditor<String> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public PVStringEditor(PreferenceValue<String> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    String initialValue = getValue();
    final JTextField field = new JTextField(initialValue);

    field.getDocument().addDocumentListener(new DocumentListener() {
      @Override
      public void removeUpdate(DocumentEvent e) {
        changedUpdate(e);
      }

      @Override
      public void insertUpdate(DocumentEvent e) {
        changedUpdate(e);
      }

      @Override
      public void changedUpdate(DocumentEvent e) {
        setValue(field.getText());
        notifyListeners();
      }
    });

    field.setEnabled(isEditable());
    return field;
  }
}
