/*
 * Created on Jun 17, 2004
 *
 */
package csbase.client.project;

import java.awt.Window;
import java.awt.datatransfer.DataFlavor;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

public interface ProjectFileContainer {
  /** O formato de dados que representa um <code>ClientProjectFile</code>. */
  /**
   * Descreve o formato de objeto que pode ser transferido pelas operaces  de
   * transferncia (drag&drop ou clipboard) na rvore.
   */
  public static final String MIME_FOR_PROJECT_FILE =
    "application/x-java-serialized-object;"+
    " class=csbase.logic.ClientProjectFile";
  public static final DataFlavor PROJECT_FILE_FLAVOR =
    new DataFlavor(MIME_FOR_PROJECT_FILE, "ClientProjectFile");

  ClientProjectFile getSelectedFile();

  ClientProjectFile[] getSelectedFiles();

  int getSelectionCount();

  Window getWindow();

  String getTitle();

  CommonClientProject getProject();

  void clearSelection();

  void clearClipboard();

  void startRenamingAction();

  void startCutAction();

  void startCopyAction();

  void startPasteAction();

  void repaint();
  
  /**
   * Habilita/desabilita a remoo de arquivos usando a tecla DELETE.
   *
   * @param enable se <code>true</code>, habilita; caso contrrio, desabilita.
   */  
  void enableDeleteAction(boolean enable);
  
  /**
   * Habilita/desabilita a atualizao da rvore de projetos usando a tecla F5.
   *
   * @param enable se <code>true</code>, habilita; caso contrrio, desabilita.
   */  
  void enableRefreshAction(boolean enable);
  
  /**
   * Habilita/desabilita edio nos ns da rvore. Usado para renomear os
   * arquivos de projeto.
   *
   * @param enable true, para habilitar a edio, ou false, caso contrrio.
   */  
  void enableRenameAction(boolean enable);
  
  /**
   * Habilita/desabilita a transferncia de arquivos por drag&drop e
   * clipboard.
   *
   * @param enable true, para habilitar a transferncia, ou false, caso
   *        contrrio.
   */  
  void enableTransferAction(boolean enable);
}
