/*
 * Created on Jun 21, 2004
 *
 */
package csbase.client.project;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

/**
 * A classe <code>TransferableNode</code> representa um ou mais objetos que
 * esto sendo transferidos por uma operao de drag&drop ou atravs do
 * clipboard.  Essa classe implementa a interface <code>Transferable</code>.
 */
public class TransferableNode implements Transferable {
  /**
   * O array com os formatos de dados de objetos que podem sofrer aes de
   * transferncia na rvore de projeto.
   */
  private final DataFlavor[] _flavors ;

  /** O objeto que est sendo transferido. */
  private final Object _value;

  /**
   * Obtm o objeto que est sendo transferido, de acordo com o formato
   * especificado.
   *
   * @param flavor formato do dado requisitado. 
   *        Deve ser <code>ProjectFileContainer.PROJECT_FILE_FLAVOR</code>.
   *
   * @return uma instncia de ObjectToTransfer encapsulando os arquivos e/ou  
   *          diretrios sendo transferidos.
   * @throws UnsupportedFlavorException se o formato do dado sendo transferido 
   *          no for <code>ProjectFileContainer.PROJECT_FILE_FLAVOR</code>.
   */
  public synchronized Object getTransferData(DataFlavor flavor)
  throws UnsupportedFlavorException {
    if (!isDataFlavorSupported(flavor)) {
      throw new UnsupportedFlavorException(flavor);
    }
    return _value;
  }

  /**
   * Obtm os formatos de dados que podem ser transferidos.
   *
   * @return .
   */
  public DataFlavor[] getTransferDataFlavors() {
    return _flavors;
  }

  /**
   * Verifica se esse objeto suporta um determinado formato de dados para
   * transferncia.
   *
   * @param flavor formato de dados a ser verificado se  suportado pelo objeto 
   *        sendo transferido.
   *
   * @return true se o objeto sendo transferido suporta o formato de dados.
   */
  public boolean isDataFlavorSupported(DataFlavor flavor) {
    for (DataFlavor aFlavor : _flavors) {
      if (aFlavor.equals(flavor)) {
        return true ;
      }
    }
    
    return false;
  }

  /**
   * Constri uma representao dos objetos da rvore que sero transferidos.
   *
   * @param value O objeto a ser transferido.
   * @param flavors formatos de dados suportados pelo objeto a ser transferido.
   */
  public TransferableNode(Object value, DataFlavor[] flavors) {
    _value = value;
    _flavors = flavors;
  }
}
