/*
 * $Id: CommonProjectOpenAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.ProjectOpenDialog;
import csbase.client.project.ProjectTree;

/**
 * Ao que abre um projeto de um usurio. Utiliza um dilogo que seleciona
 * projeto de uma lista e abre o projeto selecionado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonProjectOpenAction extends ProjectAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    openDialog();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_SELECTION");
  }

  /**
   * Abre o dilogo.
   */
  protected void openDialog() {
    try {
      new ProjectOpenDialog(getWindow());
    }
    catch (Exception e) {
      e.printStackTrace();
    }

  }

  /**
   * Construtor.
   * 
   * @param treeView a rvore.
   */
  public CommonProjectOpenAction(final ProjectTree treeView) {
    super(treeView);
  }
}
