package csbase.client.project.tasks;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.project.ClientProjectFileProperties;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;

/**
 * Renderizador para tipo de arquivo, representado pelo cone associado ao tipo.
 * O tooltip da clula ser a descrio do tipo de arquivo.
 * 
 * @author tatimf
 */
public class FileTypeIconCellRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    ImageIcon icon = null;
    ClientProjectFile file = null;
    if (value != null) {
      file = (ClientProjectFile) value;
      icon = ClientProjectFileProperties.getImageIcon(file);
      ProjectFileType type = ProjectFileType.getFileType(file.getType());
      setToolTipText(type.getDescription());
    }
    setIcon(icon);

    if (isSelected) {
      setBackground(table.getSelectionBackground());
    }
    else {
      setBackground(table.getBackground());
    }
    return this;
  }
}
