/*
 * HttpProxy.java
 * 
 * @author Andr Luiz Clinio $Revision: 150777 $ - $Date: 2006-08-15 11:01:24
 * -0300 (Tue, 15 Aug 2006) $
 */
package csbase.client.remote.srvproxies;

import javax.swing.JFrame;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.StandardErrorDialogs;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.HttpServiceInterface;

/**
 * Classe que modela um proxy para o HttpService.
 * 
 * @author Taciana Melcop
 */
public class HttpProxy {
  /** Texto de falha do PROXY */
  static String failureMessage = LNG.get("HTTP_PROXY_FAILURE");

  /** Texto de sucesso do PROXY */
  static String successMessage = LNG.get("HTTP_PROXY_SUCCESS");

  /** Ttulo da janela do PROXY */
  static String title = LNG.get("HTTP_PROXY_TITLE");

  /** Constante que representa o download */
  private static final String DOWNLOAD = "download";

  /** Constante que representa o upload */
  private static final String UPLOAD = "upload";

  /**
   * Mtodo de aviso de erro
   * 
   * @param msg mensagem a ser exibida.
   */
  private static void showError(String msg) {
    DesktopFrame dsk = DesktopFrame.getInstance();
    if (dsk == null) {
      return;
    }
    JFrame mainFrame = dsk.getDesktopFrame();
    if (mainFrame == null) {
      return;
    }
    StandardErrorDialogs.showErrorDialog(mainFrame, title, msg);
  }

  /**
   * Obtm a URL atravs da qual o arquivo deve ser obtido.
   * 
   * @param projectId Identificador do projeto.
   * @param filePath caminho do arquivo local no projeto.
   * 
   * @return String que representa a URL do arquivo ou <code>null</code> caso
   *         ocorra algum problema durante a construo da url.
   */
  public static String getDownloadURL(Object projectId, String[] filePath) {
    return getURL(projectId, filePath, null, DOWNLOAD);
  }

  /**
   * Obtem a url atraves da qual o arquivo deve ser inserido.
   * 
   * @param projectId Identificador do projeto.
   * @param filePath caminho do arquivo local no projeto.
   * @param fileType .
   * 
   * @return String que representa a url do arquivo
   */
  public static String getUploadURL(Object projectId, String[] filePath,
    String fileType) {
    return getURL(projectId, filePath, fileType, UPLOAD);
  }

  /**
   * Obtem a URL atraves da qual o arquivo deve ser acessado.
   * 
   * @param projectId Identificador do projeto.
   * @param filePath caminho do arquivo local no projeto.
   * @param fileType Tipo do arquivo no caso do upload
   * @param type .
   * @return String que representa a url do arquivo ou <code>null</code> caso
   *         ocorra algum problema durante a construo da url.
   */
  private static String getURL(final Object projectId, final String[] filePath,
    final String fileType, final String type) {
    DesktopFrame dsk = DesktopFrame.getInstance();
    JFrame mainFrame = dsk.getDesktopFrame();
    if (mainFrame == null) {
      showError(failureMessage);
      return null;
    }
    DesktopTask task = new DesktopTask() {
      @Override
      public void performTask() throws Exception {
        String userId = ClientRemoteMonitor.getInstance().getLogin();
        String password = ClientRemoteMonitor.getInstance().getPassword();
        HttpServiceInterface httpService = ClientRemoteLocator.httpService;
        if (type.equals(DOWNLOAD)) {
          setResult(httpService.getDownloadURL(userId, password, projectId,
            filePath));
        }
        else {
          setResult(httpService.getUploadURL(userId, password, projectId,
            filePath, fileType));
        }
      }
    };
    task.start(DesktopFrame.getInstance().getDesktopFrame(), title,
      successMessage);
    /* Informa se ocorreu uma exceo */
    Exception exception = task.getException();
    if (exception != null) {
      showError(exception.getMessage());
      return null;
    }
    String result = (String) task.getResult();
    if (result == null) {
      showError(LNG.get("HTTP_URL_ERROR"));
    }
    return result;
  }

  /**
   * Ajuste dos textos
   * 
   * @param proxyTitle o ttulo.
   * @param proxyFailureText mensagem de falha
   * @param proxySuccessText de sucesso
   */
  public static void setTexts(String proxyTitle, String proxyFailureText,
    String proxySuccessText) {
    title = proxyTitle;
    failureMessage = proxyFailureText;
    successMessage = proxySuccessText;
  }
}
