package csbase.client.remote.srvproxies;

import java.awt.Window;
import java.util.Set;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.CommandSubmission;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SchedulerServiceInterface;

/**
 * Classe que modela um proxy para a submisso de tarefas ao schedulerService.
 * 
 * @author valeria
 */
public class SchedulerProxy {

  /**
   * Mtodo que remove um comando da fila de espera.
   * 
   * @param window a janela chamadora do mtodo.
   * @param commandId identificador do comando.
   * @return <tt>true</tt> se o comando foi removido com sucesso.
   */
  public static boolean removeCommand(final Window window,
    final Object commandId) {
    final SchedulerServiceInterface schedulerService =
      ClientRemoteLocator.schedulerService;
    if (schedulerService == null) {
      showError(LNG.get("SCHEDULER_NO_SERVER_ERROR"), null);
      return false;
    }
    RemoteTask<Boolean> task = new RemoteTask<Boolean>() {
      @Override
      public void performTask() throws Exception {
        setResult(schedulerService.removeCommand(commandId));
      }
    };
    task.execute(window, LNG.get("SGA_COMMAND_TITLE"), LNG
      .get("SGA_COMMAND_MESSAGE"));
    return task.getResult();
  }

  /**
   * Mtodo de aviso de erro
   * 
   * @param msg mensagem a ser exibida.
   * @param e exceo causadora do erro (ou null)
   */
  private static void showError(String msg, Exception e) {
    String title =
      LNG.get("ERRO") + " - " + LNG.get("SCHEDULER_ACCESSING_TITLE");
    if (e != null) {
      StandardErrorDialogs.showErrorDialog(null, title, msg, e);
    }
    else {
      StandardErrorDialogs.showErrorDialog(null, title, msg);
    }
  }

  /**
   * Mtodo para solicitar a execuo de um comando.
   * 
   * @param window a janela chamadora do mtodo.
   * @param commandSubmission informaes para a submisso do comando.
   * 
   * @return o identificador do comando ou null em caso de erro.
   */
  public static Set<CommandInfo> submitCommand(Window window,
    final CommandSubmission commandSubmission) {
    final SchedulerServiceInterface schedulerService =
      ClientRemoteLocator.schedulerService;
    if (schedulerService == null) {
      showError(LNG.get("SCHEDULER_NO_SERVER_ERROR"), null);
      return null;
    }
    RemoteTask<Set<CommandInfo>> task = new RemoteTask<Set<CommandInfo>>() {
      @Override
      public void performTask() throws Exception {
        setResult(schedulerService.submitCommand(commandSubmission));
      }
    };
    boolean execute =
      task.execute(window, LNG.get("SCHEDULER_COMMAND_TITLE"), LNG
        .get("SCHEDULER_COMMAND_MESSAGE"));

    if (execute) {
      return task.getResult();
    }
    return null;
  }
}
