package csbase.client.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * A classe <code>FormattedDate</code> fornece uma extenso de 
 * <code>java.util.Date</code> que j formata a data no formato mais comum.
 * Caso necessrio,  possvel fornecer um formatador diferente do padro.
 *
 * @author Leonardo Barros
 */
public class FormattedDate extends Date {
  private DateFormat formatter;

  public FormattedDate(long date) {
    this(date, new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss"));
  }

  public FormattedDate(long date, DateFormat formatter) {
    super(date);
    this.formatter = formatter;
  }

  public String toString() {
    return formatter.format(this);
  }

}
                       
