/*
 * MetalThemeAdapter.java
 *
 * $Author: clinio $
 * $Revision: 36553 $  - $Date: 2006-02-02 18:35:30 -0200 (Thu, 02 Feb 2006) $
 */
package csbase.client.util;

import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

/**
 * A classe <code>MetalThemeAdapter</code>  responsvel por adaptar o Look and
 * Feel do Metal para o CSBase.
 */
public class MetalThemeAdapter extends DefaultMetalTheme {
  private static MetalThemeAdapter instance = new MetalThemeAdapter();
  private ColorUIResource primary1 = new ColorUIResource(102, 102, 170);
  private ColorUIResource primary2 = new ColorUIResource(114, 152, 224);
  private ColorUIResource primary3 = new ColorUIResource(153, 204, 255);
  private ColorUIResource secondary1 = new ColorUIResource(102, 102, 102);
  private ColorUIResource secondary2 = new ColorUIResource(180, 180, 180);
  private ColorUIResource secondary3 = new ColorUIResource(228, 228, 228);
  
  public static MetalThemeAdapter getInstance() {
    return instance;
  }

  public ColorUIResource getPrimary1() {
    return primary1;
  }

  public ColorUIResource getPrimary2() {
    return primary2;
  }

  public ColorUIResource getPrimary3() {
    return primary3;
  }

  public ColorUIResource getSecondary1() {
    return secondary1;
  }

  public ColorUIResource getSecondary2() {
    return secondary2;
  }

  public ColorUIResource getSecondary3() {
    return secondary3;
  }
}
