package csbase.client.util;

import java.util.Comparator;

public abstract class ReversibleComparator implements Comparator {
  int colIndex = 0;
  protected boolean ascending = true;

  void setColumnIndex(int columnIndex) {
    this.colIndex = columnIndex;
  }

  void inverseOrder() {
    this.ascending = !this.ascending;
  }

  void setAscendingOrder(boolean ascending) {
    this.ascending = ascending;
  }

  public int compare(Object a, Object b) {
    if (ascending) {
      return compareReverse(a, b);
    }
    else {
      return compareReverse(b, a);
    }
  }

  public abstract int compareReverse(Object a, Object b);
}
