package csbase.client.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

import javax.swing.tree.TreeNode;

public final class ThrowableTreeNode implements TreeNode {
  private ThrowableTreeNode parentTreeNode;
  private ThrowableTreeNode childTreeNode;
  private Throwable throwable;

  public ThrowableTreeNode(Throwable throwable) {
    this(null, throwable);
  }

  private ThrowableTreeNode(
    ThrowableTreeNode parentTreeNode, Throwable throwable) {
    this.parentTreeNode = parentTreeNode;
    this.throwable = throwable;
    Throwable cause = throwable.getCause();
    if (cause != null && cause != this.throwable) {
      this.childTreeNode = new ThrowableTreeNode(this, cause);
    }
  }

  public Enumeration children() {
    return new CauseEnumeration();
  }

  public boolean equals(Object object) {
    if (object == null) {
      return false;
    }
    if (!object.getClass().equals(getClass())) {
      return false;
    }
    ThrowableTreeNode node = (ThrowableTreeNode)object;
    return node.throwable.equals(this.throwable);
  }

  public boolean getAllowsChildren() {
    return false;
  }

  public TreeNode getChildAt(int childIndex) {
    if (this.childTreeNode != null) {
      if (childIndex == 0) {
        return this.childTreeNode;
      }
    }
    return null;
  }

  public int getChildCount() {
    if (this.childTreeNode != null) {
      return 1;
    }
    return 0;
  }

  public int getIndex(TreeNode node) {
    if (node.equals(this.childTreeNode)) {
      return 0;
    }
    return -1;
  }

  public TreeNode getParent() {
    return this.parentTreeNode;
  }

  public Throwable getThrowable() {
    return this.throwable;
  }

  public int hashCode() {
    return this.throwable.hashCode();
  }

  public boolean isLeaf() {
    return false;
  }

  public String toString() {
    return trimWhiteSpaces(this.throwable.toString());
  }

  private static String trimWhiteSpaces(String text) {
    String[] tokens = text.split("[\b\n\t\f\r]");
    String newText = "";
    String separator = "";
    for (int i = 0; i < tokens.length; i++) {
      String token = tokens[i].trim();
      if (token.length() != 0) {
        newText += separator + token;
        separator = " ";
      }
    }
    return newText;
  }
  
  private final class CauseEnumeration implements Enumeration {
    boolean wasConsumed;

    public boolean hasMoreElements() {
      if (getChildCount() != 0) {
        if (!this.wasConsumed) {
          return true;
        }
      }
      return false;
    }

    public Object nextElement() {
      if (!hasMoreElements()) {
        throw new NoSuchElementException();
      }
      this.wasConsumed = true;
      return ThrowableTreeNode.this.childTreeNode;
    }
  }
}
