package csbase.client.util.csvpanel.table;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * Um modelo que utiliza as n primeiras linhas dos dados da tabela como
 * cabealho.
 */
public class MultiHeaderTableModel implements TableModel {

  /** O modelo original da tabela. */
  private TableModel model;

  /**
   * Nmero de linhas a serem usadas como cabealho.
   */
  private int numHeaderRows;

  /**
   * Construtor.
   * 
   * @param model o modelo original.
   * @param numHeaderRows nmero de linhas a serem usadas como cabealho.
   */
  public MultiHeaderTableModel(TableModel model, int numHeaderRows) {
    this.model = model;
    this.numHeaderRows = numHeaderRows;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    return model.getRowCount() - numHeaderRows;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return model.getColumnCount();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int columnIndex) {
    if (columnIndex >= getColumnCount()) {
      return null;
    }
    StringBuilder builder = new StringBuilder();
    builder.append("<html><center>");
    for (int i = 0; i < numHeaderRows; i++) {
      Object value = model.getValueAt(i, columnIndex);
      if (value != null) {
        builder.append(value);
      }
      builder.append("<br>");
    }
    builder.append("</center></html>");
    return builder.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int columnIndex) {
    return model.getColumnClass(columnIndex);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return model.isCellEditable(rowIndex + numHeaderRows, columnIndex);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(int rowIndex, int columnIndex) {
    return model.getValueAt(rowIndex + numHeaderRows, columnIndex);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    model.setValueAt(aValue, rowIndex + numHeaderRows, columnIndex);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void addTableModelListener(TableModelListener l) {
    model.addTableModelListener(l);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void removeTableModelListener(TableModelListener l) {
    model.removeTableModelListener(l);
  }

}
