package csbase.client.util.gui;

import java.awt.Component;
import java.awt.Dimension;

/**
 * Mtodos teis para serem utilizados em componentes.
 * 
 * @author Tecgraf
 */
public class ComponentUtilities {

  /**
   * Obtm uma {@link Dimension dimenso} contendo a maior altura e largura
   * dentre os compoentes. Nessa {@link Dimension dimenso}, todos esses
   * componentes tem ao menos seu tamanho preferido.
   * 
   * @param components Componentes.
   * 
   * @return uma {@link Dimension dimenso} contendo a maior altura e largura
   *         dentre os compoentes.
   */
  public static Dimension getMaxPreferredSize(Component... components) {
    double width = 0, height = 0;
    for (Component aComponent : components) {
      Dimension preferredSize = aComponent.getPreferredSize();
      width = Math.max(width, preferredSize.getWidth());
      height = Math.max(height, preferredSize.getHeight());
    }

    return new Dimension((int) width, (int) height);
  }

  /**
   * Atribui ao tamanho preferido dos componentes, a maior altura e largura
   * dentre eles. Assim todos tero o mesmo tamanho e no mnimo seu tamanho
   * preferido.
   * 
   * @param components componentes a terem seus tamanhos modificados.
   */
  public static void setMaxPreferredSize(Component... components) {
    Dimension preferredSize = getMaxPreferredSize(components);
    for (Component aComponent : components) {
      aComponent.setPreferredSize(preferredSize);
    }
  }

  /**
   * Atribui a altura preferido dos componentes, a maior largura dentre eles.
   * Assim todos tero a mesma largura e no mnimo sua largura preferida.
   * 
   * @param components componentes a terem suas larguras modificados.
   */
  public static void setMaxPreferredWidth(Component... components) {
    Dimension maxPreferredSize = getMaxPreferredSize(components);
    for (Component aComponent : components) {
      Dimension preferredSize = aComponent.getPreferredSize();
      preferredSize.width = maxPreferredSize.width;
      aComponent.setPreferredSize(preferredSize);
    }
  }

  /**
   * Atribui a altura preferido dos componentes, a maior altura dentre eles.
   * Assim todos tero a mesma altura e no mnimo sua altura preferida.
   * 
   * @param components componentes a terem suas alturas modificados.
   */
  public static void setMaxPreferredHeight(Component... components) {
    Dimension maxPreferredSize = getMaxPreferredSize(components);
    for (Component aComponent : components) {
      Dimension preferredSize = aComponent.getPreferredSize();
      preferredSize.height = maxPreferredSize.height;
      aComponent.setPreferredSize(preferredSize);
    }
  }
}
