package csbase.client.util.gui;

import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

/**
 * Boto que pode conter simultneamente um texto, um cone  esquerda e um
 * cone  direita. Caso o apenas um dos lados do boto tenha cone,  criado
 * outro cone (vazio e de dimenses iguais ao cone existente) para ser
 * adicionado no lado oposto, de modo que o texto fique exatamente no centro do
 * boto.
 * 
 * @author Tecgraf
 */
public class MultiImageButton extends JButton {

  /** Margem vertical default do boto. */
  private static final int VERTICAL_MARGIN = 2;

  /**
   * Construtor.
   * 
   * @param leftIcon cone que ficar  esquerda do texto. Pode ser nulo.
   * @param text Texto.
   * @param rightIcon cone que ficar  direita do texto. Pode ser nulo.
   */
  public MultiImageButton(ImageIcon leftIcon, String text, ImageIcon rightIcon) {
    add(getButtonPanel(leftIcon, text, rightIcon), new GBC(0, 0).both());
  }

  /**
   * Cria um painel com os contedos do boto dispostos da seguinte forma:
   * (cone) (Texto) (cone).
   * 
   * @param leftIcon cone que ficar  esquerda do texto.
   * @param text Texto.
   * @param rightIcon cone que ficar  direita do texto.
   * 
   * @return O painl.
   */
  private JPanel getButtonPanel(Icon leftIcon, String text, Icon rightIcon) {
    JPanel buttonPanel = new JPanel(new GridBagLayout());

    if (leftIcon == null && rightIcon != null) {
      leftIcon =
        GUIUtils.createEmptyIcon(rightIcon.getIconWidth(), rightIcon
          .getIconHeight());
    }
    else {
      if (rightIcon == null && leftIcon != null) {
        rightIcon =
          GUIUtils.createEmptyIcon(leftIcon.getIconWidth(), leftIcon
            .getIconHeight());
      }
    }
    buttonPanel.add(new JLabel(leftIcon), new GBC(0, 0).east());
    int iconTextGap = getIconTextGap();
    buttonPanel.add(new JLabel(text, JLabel.CENTER), new GBC(1, 0).horizontal()
      .center().insets(new Insets(0, iconTextGap, 0, iconTextGap)));
    buttonPanel.add(new JLabel(rightIcon), new GBC(2, 0).west());
    buttonPanel.setOpaque(false);
    setMargin(new Insets(VERTICAL_MARGIN, iconTextGap, VERTICAL_MARGIN,
      iconTextGap));

    return buttonPanel;
  }
}
