/*
 * $Id: FontSize.java 71972 2008-01-10 18:27:58Z pasti $
 */
package csbase.client.util.gui.log.enums;

import csbase.client.util.gui.log.LogPanel;

/**
 * @author Tecgraf/PUC-Rio
 */
public enum FontSize {

  /**
   * Micro
   */
  MICRO(8),

  /**
   * Normal
   */
  NORMAL(12),

  /**
   * Grande
   */
  BIG(14),

  /**
   * Enorme
   */
  HUGE(18);

  /**
   * Nome do tipo
   */
  private final int size;

  /**
   * Consulta o tamanho
   * 
   * @return o tamanho
   */
  public final int getSize() {
    return size;
  }

  /**
   * Consulta o nome da fonte (traduzida)
   * 
   * @return o texto
   */
  public final String getLabel() {
    String key = String.format("%s.%s", getClass().getSimpleName(), name());
    return LogPanel.getString(key);
  }

  /**
   * Construtor
   * 
   * @param size o tamanho
   */
  private FontSize(final int size) {
    this.size = size;
  }

  /**
   * Consulta um tamanho com base no nmero
   * 
   * @param size o tamanho
   * @return a fonte
   */
  public static FontSize getFontSizeByInt(final int size) {
    for (final FontSize tp : values()) {
      if (size == tp.getSize())
        return tp;
    }
    return null;
  }
}
