package csbase.client.util.sga;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import csbase.logic.CommandSubmission;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationSuccess;

/**
 * Representa o conjunto de submisses de comandos com o resultado associado da
 * validao dos seus parmetros.
 */
public class MultipleCommandSubmission implements Iterable<CommandSubmission> {

  /**
   * A lista de submisses.
   */
  private List<CommandSubmission> submissionList;

  /**
   * O resultado da validao das configuraes para execuo.
   */
  private Validation validation;

  /**
   * Construtor.
   */
  public MultipleCommandSubmission() {
    this.submissionList = new ArrayList<CommandSubmission>();
    this.validation = new ValidationSuccess();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Iterator<CommandSubmission> iterator() {
    return submissionList.iterator();
  }

  /**
   * Retorna o resultado da validao dos comandos.
   * 
   * @return o resultado.
   */
  public Validation getValidation() {
    return validation;
  }

  /**
   * Atribui o resultado da validao dos comandos.
   * 
   * @param validation o resultado.
   */
  public void setValidation(Validation validation) {
    this.validation = validation;
  }

  /**
   * Adiciona uma nova submisso ao conjunto.
   * 
   * @param submission a nova submisso.
   */
  public void addSubmission(CommandSubmission submission) {
    this.submissionList.add(submission);
  }

  /**
   * Remove uma submisso do conjunto.
   * 
   * @param submission a submisso a ser removida.
   */
  public void removeSubmission(CommandSubmission submission) {
    this.submissionList.remove(submission);
  }

  /**
   * Remove todas as submisses do conjunto.
   */
  public void clearSubmissions() {
    this.submissionList.clear();
  }

  /**
   * Obtm a lista de submisses do conjunto.
   * 
   * @return a lista de submisses.
   */
  public List<CommandSubmission> getSubmissionList() {
    return Collections.unmodifiableList(submissionList);
  }
}
