package csbase.client.util.table;

/**
 * Fbrica de {@link CellModel Modelos de Clula}: cria modelos de clula.
 * 
 * @param <R> O tipo do valor armazenado na linha da tabela. 
 */
public interface CellModelFactory<R> {

  /**
   * Cria um modelo de clula.
   * 
   * @param rowValue O valor armazenado na linha.
   * 
   * @return Um modelo de clula.
   */
  public CellModel create(R rowValue);
}