package csbase.client.util.table;

import csbase.exception.ParseException;

/**
 * Conversor de <i>Integer</i>.
 */
public final class IntegerConverter implements Converter {
  public Object convertFromView(String value) throws ParseException {
    if (value == null) {
      throw new IllegalArgumentException("O parmetro value est nulo.");
    }
    
    try {
      return Integer.parseInt(value);
    } catch (NumberFormatException e) {
      throw new ParseException("O valor informado no  um nmero inteiro.");
    }
  }

  public String convertToView(Object value) {
    if (value == null) {
      throw new IllegalArgumentException("O parmetro value est nulo.");
    }
    return value.toString();
  }
}
