package csbase.client.util.table;

/**
 * Validador de Inteiros.
 */
public final class IntegerValidator implements Validator {

  /**
   * O mximo.
   */
  private Integer maximum;

  /**
   * O mnimo.
   */
  private Integer minimum;

  /**
   * Cria um validador de inteiros.
   * 
   * @param minimum O valor mnimo (Aceita {@code null}).
   * @param maximum O valor mximo (Aceita {@code null}).
   */
  public IntegerValidator(Integer minimum, Integer maximum) {
    if (maximum == null) {
      maximum = Integer.MAX_VALUE;
    }
    if (minimum == null) {
      minimum = Integer.MIN_VALUE;
    }
    if (maximum.compareTo(minimum) < 0) {
      throw new IllegalArgumentException(String.format(
        "O mximo %d  menor do que o mnimo %d.", maximum, minimum));
    }
    this.maximum = maximum;
    this.minimum = minimum;
  }

  public String getValidationErrorMessage(Object value) {
    Integer integerValue = (Integer) value;

    if (integerValue == null) {
      return null;
    }

    if (integerValue.compareTo(minimum) < 0) {
      return String.format("Valor abaixo do mnimo (%d).", minimum);
    }

    if (integerValue.compareTo(maximum) > 0) {
      return String.format("Valor acima do mximo (%d).", maximum);
    }

    return null;
  }
}
