/*
 * $Id:$
 */

package csbase.client.util.xmlpanel;

import java.util.List;

import javax.swing.ImageIcon;

import org.w3c.dom.Node;

/**
 * Definidor de layout de renderizao de dado XML.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface XMLPanelStyleInterface {

  /**
   * Consulta uma imagem com base em um n
   * 
   * @param node n.
   * @param textValue valor textual do n
   * @param index ndice do n em relao ao pai (negativo se for raiz).
   * @return imagem.
   */
  public ImageIcon getIcon(Node node, String textValue, int index);

  /**
   * Consulta um texto renderizado em rvore com base em um n
   * 
   * @param node n.
   * @param textValue valor textual do n
   * @param index ndice do n em relao ao pai (negativo se for raiz).
   * @return imagem.
   */
  public String getTreeText(Node node, String textValue, int index);

  /**
   * Consulta nome do definidor de layout.
   * 
   * @return nome
   */
  public String getName();

  /**
   * Indica que o um painel de dados textuais de um n  necessrio para o
   * estilo.
   * 
   * @return indicativo
   */
  public boolean isTextPanelNeeded();

  /**
   * Consulta uma lista tpica de tipos de arquivos tratveis pelo estilo.
   * 
   * @return a lista
   */
  public List<String> getTipicalFileTypes();

}
