/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.commands.newview.AbstractCommandView;
import csbase.client.algorithms.commands.newview.CommandViewType;
import csbase.client.algorithms.commands.newview.LogTabConfiguration;
import csbase.client.algorithms.commands.newview.MatchLogTabConfigurationsTask;
import csbase.client.kernel.ClientException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.ProgressData;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

class NodeCommandView
extends AbstractCommandView {
    private int nodeId;

    public NodeCommandView(int nodeId, CommandInfo cmd, AlgorithmConfigurator configurator) throws ClientException {
        super(CommandViewType.NODE, cmd, configurator);
        this.nodeId = nodeId;
        this.idForLogPattern = String.valueOf(nodeId);
    }

    @Override
    protected String getFinalizationTypeDescription() {
        CommandFinalizationInfo finalizationInfo = this.command.getFinalizationInfo();
        if (finalizationInfo.getInfoType() == CommandFinalizationInfo.FinalizationInfoType.SIMPLE) {
            return super.getFinalizationTypeDescription();
        }
        ExtendedCommandFinalizationInfo flowfinalizationInfo = (ExtendedCommandFinalizationInfo)finalizationInfo;
        CommandFinalizationInfo nodeFinalizationInfo = flowfinalizationInfo.getFinalizationInfoForNode(this.nodeId);
        switch (nodeFinalizationInfo.getFinalizationType()) {
            case EXECUTION_ERROR: {
                return this.getFinalizationTypeDescription(CommandFinalizationType.EXECUTION_ERROR, nodeFinalizationInfo.getExitCode());
            }
            case SUCCESS: {
                return this.getFinalizationTypeDescription(CommandFinalizationType.SUCCESS, null);
            }
            case NO_EXIT_CODE: {
                return this.getFinalizationTypeDescription(CommandFinalizationType.NO_EXIT_CODE, null);
            }
        }
        return this.getFinalizationTypeDescription(CommandFinalizationType.END, null);
    }

    @Override
    protected ProgressData getCommandProgress() {
        Map progressDataMap = this.command.getProgressDataMap();
        return (ProgressData)progressDataMap.get(this.nodeId);
    }

    @Override
    protected Map<LogTabConfiguration, Set<ClientProjectFile>> getMatchingLogFiles(List<LogTabConfiguration> tabConfiguration) {
        String[] logsDir = this.command.getPersistencyPath();
        MatchLogTabConfigurationsTask task = new MatchLogTabConfigurationsTask(logsDir, tabConfiguration);
        String message = LNG.get((String)(NodeCommandView.class.getSimpleName() + ".message.task.load.logs"));
        if (task.execute(this.owner, this.getTitle(), message)) {
            return (Map)task.getResult();
        }
        String errorMsg = LNG.get((String)(NodeCommandView.class.getSimpleName() + ".error.task.load.logs"), (Object[])new Object[]{this.command.getId()});
        StandardDialogs.showErrorDialog((Component)this.mainPanel.getParent(), (String)this.getTitle(), (String)errorMsg);
        return null;
    }

    @Override
    public String getTitle() {
        return LNG.get((String)(NodeCommandView.class.getSimpleName() + ".window.title"), (Object[])new Object[]{this.configurator.getAlgorithmName(), this.configurator.getAlgorithmVersionId()});
    }
}

