/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.ClientFileLockListener;
import csbase.logic.ClientProjectFile;
import csbase.logic.FileLockEvent;
import csbase.util.messages.IMessageListener;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class ClientFileLock {
    private LockStatus lockStatus;
    private ClientProjectFile file;
    private ClientFileLockListener listener;
    private Object lockId;

    private ClientFileLock(ClientProjectFile file) {
        this.file = file;
        this.lockStatus = LockStatus.LOCK_DENIED;
    }

    private void acquireExclusiveLock(Window window, final long timeout) {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                ClientFileLock.this.lockId = ClientFileLock.this.file.acquireExclusiveLock(ClientFileLock.this.listener, timeout);
                ClientFileLock.this.listener = new ClientFileLockListener(ClientFileLock.this.lockId);
                MessageProxy.addListener((IMessageListener)ClientFileLock.this.listener, FileLockEvent.class);
                this.setResult(ClientFileLock.this.listener.waitLock());
            }
        };
        if (task.execute(window, this.getWindowTitle(), String.format(LNG.get((String)"ClientFileLock.acquire.exclusive.lock.msg"), this.file.getName()))) {
            if (((Boolean)task.getResult()).booleanValue()) {
                this.lockStatus = LockStatus.LOCK_EXCLUSIVE;
                MessageProxy.removeListener((IMessageListener)this.listener);
            }
        } else if (task.wasCancelled()) {
            this.cancelLock(window);
            MessageProxy.removeListener((IMessageListener)this.listener);
        }
    }

    private void acquireExclusiveLock(Window window) {
        RemoteTask<Object> task = new RemoteTask<Object>(){

            protected void performTask() throws Exception {
                ClientFileLock.this.lockId = ClientFileLock.this.file.acquireExclusiveLock();
                this.setResult(ClientFileLock.this.lockId);
            }
        };
        if (task.execute(window, this.getWindowTitle(), String.format(LNG.get((String)"ClientFileLock.acquire.exclusive.lock.msg"), this.file.getName()))) {
            if (task.getResult() != null) {
                this.lockStatus = LockStatus.LOCK_EXCLUSIVE;
            }
        } else if (task.wasCancelled()) {
            this.cancelLock(window);
        }
    }

    private void acquireSharedLock(Window window, final long timeout) {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                ClientFileLock.this.lockId = ClientFileLock.this.file.acquireSharedLock(ClientFileLock.this.listener, timeout);
                ClientFileLock.this.listener = new ClientFileLockListener(ClientFileLock.this.lockId);
                MessageProxy.addListener((IMessageListener)ClientFileLock.this.listener, FileLockEvent.class);
            }
        };
        if (task.execute(window, this.getWindowTitle(), String.format(LNG.get((String)"ClientFileLock.acquire.shared.lock.msg"), this.file.getName()))) {
            if (((Boolean)task.getResult()).booleanValue()) {
                this.lockStatus = LockStatus.LOCK_SHARED;
                MessageProxy.removeListener((IMessageListener)this.listener);
            }
        } else if (task.wasCancelled()) {
            this.cancelLock(window);
            MessageProxy.removeListener((IMessageListener)this.listener);
        }
    }

    private void acquireSharedLock(Window window) {
        RemoteTask<Object> task = new RemoteTask<Object>(){

            protected void performTask() throws Exception {
                ClientFileLock.this.lockId = ClientFileLock.this.file.acquireSharedLock();
                this.setResult(ClientFileLock.this.lockId);
            }
        };
        if (task.execute(window, this.getWindowTitle(), String.format(LNG.get((String)"ClientFileLock.acquire.shared.lock.msg"), this.file.getName()))) {
            if (task.getResult() != null) {
                this.lockStatus = LockStatus.LOCK_SHARED;
            }
        } else if (task.wasCancelled()) {
            this.cancelLock(window);
        }
    }

    private void _releaseLock(Window window) {
        if (this.lockId == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                ClientFileLock.this.file.releaseLock(ClientFileLock.this.lockId);
            }
        };
        task.execute(window, this.getWindowTitle(), String.format(LNG.get((String)"ClientFileLock.release.lock.msg"), this.file.getName()), 300, 0);
        this.lockStatus = LockStatus.LOCK_RELEASED;
    }

    private void cancelLock(Window window) {
        if (this.listener != null) {
            MessageProxy.removeListener((IMessageListener)this.listener);
        }
        this._releaseLock(window);
    }

    private String getWindowTitle() {
        return LNG.get((String)"ClientFileLock.window.title");
    }

    public void releaseLock(Window window) {
        if (this.lockStatus == LockStatus.LOCK_EXCLUSIVE || this.lockStatus == LockStatus.LOCK_SHARED) {
            this._releaseLock(window);
        }
    }

    public LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public static ClientFileLock acquireExclusiveLock(Window window, ClientProjectFile file, long timeout) {
        ClientFileLock clientFileLock = new ClientFileLock(file);
        clientFileLock.acquireExclusiveLock(window, timeout);
        return clientFileLock;
    }

    public static ClientFileLock acquireExclusiveLock(Window window, ClientProjectFile file) {
        ClientFileLock clientFileLock = new ClientFileLock(file);
        clientFileLock.acquireExclusiveLock(window);
        return clientFileLock;
    }

    public static ClientFileLock acquireSharedLock(Window window, ClientProjectFile file, long timeout) {
        ClientFileLock clientFileLock = new ClientFileLock(file);
        clientFileLock.acquireSharedLock(window, timeout);
        return clientFileLock;
    }

    public static ClientFileLock acquireSharedLock(Window window, ClientProjectFile file) {
        ClientFileLock clientFileLock = new ClientFileLock(file);
        clientFileLock.acquireSharedLock(window);
        return clientFileLock;
    }

    public static enum LockStatus {
        LOCK_EXCLUSIVE,
        LOCK_DENIED,
        LOCK_SHARED,
        LOCK_RELEASED;

    }
}

