package csbase.client.algorithms.validation;

import csbase.client.algorithms.parameters.TableParameterView;
import csbase.logic.algorithms.validation.Validation;

/**
 * Representa o resultado de validao de um parmetro do tipo tabela, que
 * indica a clula que gerou o resultado.
 */
public class TableCellValidationResult extends ViewValidationResult {

  /**
   * ndice da coluna na tabela.
   */
  private int columnIndex;
  /**
   * ndice da linha na tabela.
   */
  private int rowIndex;

  /**
   * Construtor.
   * 
   * @param validation o resultado da validao.
   * @param element a viso da tabela.
   * @param col o ndice da coluna da clula.
   * @param row o ndice da linha da clula.
   */
  public TableCellValidationResult(Validation validation,
    TableParameterView element, int col, int row) {
    super(validation, element);
    this.columnIndex = col;
    this.rowIndex = row;
  }

  /**
   * Retorna o ndice da coluna da clula que gerou o resultado da validao.
   * 
   * @return o ndice da coluna.
   */
  public int getColumnIndex() {
    return columnIndex;
  }

  /**
   * Retorna o ndice da linha da clula que gerou o resultado da validao.
   * 
   * @return rowIndex o ndice da linha.
   */
  public int getRowIndex() {
    return rowIndex;
  }

}