/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.models;

import java.util.List;

/**
 * Informaes de uma tabela de comandos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class CommandsTableDTO {

  /** Identificador nico da tabela. */
  private final String id;
  /** Identificador nico do filtro de comandos. */
  private final String filterId;
  /** Lista ordenada de identificadores nicos das colunas. */
  private final List<String> columnsId;

  /** Identificador da coluna que ser utilizada para ordenar a tabela. */
  private final String orderby;
  /** Indica se a ordenao  crescente. */
  private final boolean ascending;
  
  /**
   * Tempo mnimo que o usurio tem para editar uma clula da tabela sem que
   * essa edio seja cancelada por uma atualizao da tabela.
   */
  private Long cellsEditingMinTime;

  /**
   * Construtor.
   * 
   * @param id Identificador nico da tabela.
   * @param filterId Identificador nico do filtro de comandos.
   * @param columnsId Lista ordenada de identificadores nicos das colunas.
   * @param orderby Identificador da coluna que ser utilizada para ordenar a
   *        tabela. Pode ser null.
   * @param ascending Indica se a ordenao  crescente.
   * @param cellsEditingMinTime Tempo mnimo que o usurio tem para editar uma
   *        clula da tabela sem que essa edio seja cancelada por uma
   *        atualizao da tabela.
   */
  public CommandsTableDTO(String id, String filterId, List<String> columnsId,
    String orderby, boolean ascending, Long cellsEditingMinTime) {
    this.id = id;
    this.filterId = filterId;
    this.columnsId = columnsId;
    this.orderby = orderby;
    this.ascending = ascending;
    this.cellsEditingMinTime = cellsEditingMinTime;
  }

  /**
   * Obtm o identificador nico desta tabela.
   * 
   * @return o identificador nico desta tabela.
   */
  public String getId() {
    return id;
  }

  /**
   * Obtm o identificador nico do filtro de comandos.
   * 
   * @return o identificador nico do filtro de comandos.
   */
  public String getFilterId() {
    return filterId;
  }

  /**
   * Obtm uma lista ordenada de identificadores nicos das colunas.
   * 
   * @return lista ordenada de identificadores nicos das colunas.
   */
  public List<String> getColumnsId() {
    return columnsId;
  }

  /**
   * Obtm o identificador da coluna que ser utilizada para ordenar a tabela.
   * 
   * @return o identificador da coluna que ser utilizada para ordenar a tabela.
   *         Caso a ordem no importe, ser retornado null.
   */
  public String getOrderby() {
    return orderby;
  }

  /**
   * Obtm o tempo mnimo que o usurio tem para editar uma clula da tabela sem
   * que essa edio seja cancelada por uma atualizao da tabela.
   * 
   * @return tempo mnimo que o usurio tem para editar uma clula da tabela sem
   *         que essa edio seja cancelada por uma atualizao da tabela.
   *         {@code null} significa que no foi atribudo um valor no xml.
   */
  public Long getCellsEditingMinTime() {
    return cellsEditingMinTime;
  }

  /**
   * Verifica se  para ordenar de forma crescente.
   * 
   * @return <tt>true</tt> indica para ordenar de forma crescente.
   */
  public boolean isAscending() {
    return ascending;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((id == null) ? 0 : id.hashCode());
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final CommandsTableDTO other = (CommandsTableDTO) obj;
    if (id == null) {
      if (other.id != null) {
        return false;
      }
    }
    else if (!id.equals(other.id)) {
      return false;
    }
    return true;
  }
}
