package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo o identificador do comando que est persistido. <br>
 *
 * @author Tecgraf / PUC-Rio
 */
public class IdColumn extends AbstractCommandsTableColumn {

    /**
     * Construtor.
     *
     * @param id Identificador da coluna.
     * @param appRegistry registro da aplicao que ser utilizado para se obter o
     *        nome da coluna de acordo com o {@link Locale}.
     */
  public IdColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    return cmd.getId().toString();
  }
}

