package csbase.client.applications.flowapplication.filters;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;

import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;

/**
 * Filtro de highlight
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class HighlightElementFilter extends WorkspaceFilter {
  /**
   * Coleo de elementos.
   */
  private Collection<GraphElement> elementCollection;

  /**
   * Construtor
   * 
   * @param workspace
   */
  public HighlightElementFilter(final Workspace workspace) {
    super(workspace);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackMove(final Point2D pt, final MouseEvent ev) {
    restart();
    final PickGraphMessage message = new PickGraphMessage();
    message.sendVO(this);
    final Graph graph = message.getGraph();
    this.elementCollection = graph.getElementCollection(pt);
    if (!this.elementCollection.isEmpty()) {
      final Iterator<GraphElement> elementIterator =
        this.elementCollection.iterator();
      while (elementIterator.hasNext()) {
        final GraphElement element = elementIterator.next();
        element.turnOnHighlight(pt);
      }
      repaint();
    }
    else {
      this.elementCollection = null;
    }
    super.callbackMove(pt, ev);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(final Graph graph, final GraphElement element) {
    restart();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(final Graph graph) {
    restart();
  }

  /**
   * Reinicializao.
   */
  private void restart() {
    if (this.elementCollection != null) {
      final Iterator<GraphElement> elementIterator =
        this.elementCollection.iterator();
      while (elementIterator.hasNext()) {
        final GraphElement element = elementIterator.next();
        element.turnOffHighlight();
      }
      repaint();
      this.elementCollection = null;
    }
  }
}
