package csbase.client.applications.flowapplication.graph.actions;

import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import csbase.client.applications.flowapplication.graph.Graph;

/**
 * Ao abstrata de menu popup para o fluxo de algoritmos.
 * 
 * @author lmoreira
 */
public abstract class GraphAction extends Action {
  /**
   * O fluxo de algoritmos.
   */
  private final Graph graph;

  /**
   * Cria a ao.
   * 
   * @param graph O fluxo (No aceita {@code null}).
   * @param nameKey O nome da chave do mecanismo de internacionalizao com o
   *        nome da ao.
   * @param icon O cone da ao.
   */
  protected GraphAction(final Graph graph, final String nameKey,
    final ImageIcon icon) {
    super(nameKey, icon);
    this.graph = graph;
  }

  /**
   * Cria a ao.
   * 
   * @param graph O fluxo (No aceita {@code null}).
   * @param nameKey O nome da chave do mecanismo de internacionalizao com o
   *        nome da ao.
   * @param icon O cone da ao.
   * @param acceleratorKeyStroke A tecla que dispara a ao.
   */
  protected GraphAction(final Graph graph, final String nameKey,
    final ImageIcon icon, final KeyStroke acceleratorKeyStroke) {
    super(nameKey, icon, acceleratorKeyStroke);
    this.graph = graph;
  }

  /**
   * Obtm o fluxo de algoritmos.
   * 
   * @return O fluxo de algoritmos.
   */
  protected final Graph getGraph() {
    return this.graph;
  }
}
