/*
 * $Id:$
 */

package csbase.client.applications.imageviewer.actions.effects;

import java.awt.event.ActionEvent;

import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;
import csbase.client.applications.imageviewer.effects.AbstractEffect;

/**
 * Classe abstrata de alterao de imagem com efeitos.
 * 
 * @author Tecgraf
 * @param <T> O efeito na imagem.
 */
abstract public class ImageViewerEffectAction<T extends AbstractEffect> extends
  ImageViewerAction {

  /**
   * O efeito.
   */
  final private T effect;

  /**
   * {@inheritDoc}
   */
  @Override
  final protected void handleActionPerformed(ActionEvent ae) {
    final ImageViewer application = getApplication();
    final ImageViewerEffectDialog<T> dialog =
      new ImageViewerEffectDialog<T>(application, effect);
    dialog.initPreview();
    dialog.setVisible(true);
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   * @param effect o efeito.
   */
  public ImageViewerEffectAction(ImageViewer application, T effect) {
    super(application);
    this.effect = effect;
  }

  /**
   * Retorna
   * 
   * @return effect
   */
  public T getEffect() {
    return effect;
  }
}