/*
 * $Id: GrayScaleEffect.java 111197 2010-10-11 18:48:35Z clinio $
 */
package csbase.client.applications.imageviewer.effects;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;

import javax.swing.JPanel;

import csbase.client.applications.imageviewer.ImageViewer;

/**
 * Efeito para criar tons de cinza.
 * 
 * @author Tecgraf/PUC-Rio
 */
final public class GrayScaleEffect extends AbstractEffect {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public GrayScaleEffect(ImageViewer application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public JPanel getParameterPanel() {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public BufferedImage transformImage(BufferedImage image) {
    final ColorSpace cSpace = ColorSpace.getInstance(ColorSpace.CS_GRAY);
    BufferedImageOp gOp = new ColorConvertOp(cSpace, null);
    BufferedImage newImage = gOp.filter(image, null);
    return newImage;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void resetParameters() {
  }
}
