/*
 * $Id$
 */

package csbase.client.externalresources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import csbase.util.ZipUtils;

/**
 * Representa um conjunto de arquivos zipados.
 * 
 * @author Tecgraf
 */
public class ZipLocalFile implements LocalFile {

  /**
   * Bytes dos arquivos zipados.
   */
  private byte[] data;

  /**
   * Nome do arquivo .zip.
   */
  private String name;

  /**
   * Constroi uma representao de um arquivo que s existe aqui em memria.
   * Este arquivo ser um zip dos demais arquivos passados neste construtor.
   * 
   * @param name Nome do arquivo zip em memria, aqui representado.
   * @param files Arquivos a serem zipados.
   * 
   * @throws IOException Caso no seja possvel zipar os arquivos.
   * @throws IllegalArgumentException
   * @throws OutOfMemoryError
   */
  public ZipLocalFile(String name, File[] files) throws IOException {
    if (null == files || 0 == files.length) {
      throw new IllegalArgumentException("Tentando criar um zip vazio");
    }

    this.data = ZipUtils.zipFiles(files);
    this.name = name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canRead() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canWrite() {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean exists() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public InputStream getInputStream() {
    return new ByteArrayInputStream(data);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public long getLength() {
    return data.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getAbsolutePath() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public OutputStream getOutputStream(boolean append) {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isDirectory() {
    return false;
  }
}
