package csbase.client.facilities.commandtable;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/**
 * Renderizador de clulas que representam o estado de um comando em uma tabela.
 */
public class CommandStatusCellRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
      row, column);

    setHorizontalAlignment(CENTER);

    if (value == null) {
      setText("-----");
    }
    else {
      CommandStatusCellData statusData = (CommandStatusCellData) value;
      Icon icon = statusData.getIcon();
      setIcon(icon);
      String tooltip = statusData.getTooltip();
      setToolTipText(tooltip);
      setText("");
    }

    /*
     *  necessrio fazer este teste por causa do bug:
     * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4795987
     */
    if (this.isEnabled() != table.isEnabled()) {
      this.setEnabled(table.isEnabled());
    }
    return this;
  }

}