package csbase.client.facilities.configurabletable.stringprovider;

import csbase.client.applications.Application;

/**
 * Classe que retorna strings internacionalizadas a partir de uma aplicao
 * CSBASE.
 * 
 * @author Tecgraf
 */
public class ApplicationStringProvider implements IStringProvider {

  /**
   * Referncia para uma aplicao CSBASE que ser utilizada para obter as
   * strings internacionalizadas.
   */
  private Application application;

  /**
   * Construtor.
   * 
   * @param application
   */
  public ApplicationStringProvider(Application application) {
    this.application = application;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getString(String key) {
    return application.getString(key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return (application != null) ? application.getId() : super.toString();
  }

}
