package csbase.client.facilities.configurabletable.table;

/**
 * Classe auxiliar que encapsula o estado de uma coluna. Esta classe apenas
 * agrupa as informaes do estado de uma coluna para facilitar a persitncia
 * desta coluna nas preferncias do usurio.
 * 
 * @author Tecgraf
 */
public class ColumnState {

  /** Identificador da coluna. */
  private String columnId;

  /** Flag que indica se a coluna est visvel. */
  private boolean visible;

  /**
   * Construtor padro.
   * 
   * @param columnId - identificador da coluna.
   * @param visible - flag que indica se a coluna est visvel.
   */
  public ColumnState(String columnId, boolean visible) {
    super();
    this.columnId = columnId;
    this.visible = visible;
  }

  /**
   * Identificador da coluna.
   * 
   * @return identificador da coluna.
   */
  public String getColumnId() {
    return columnId;
  }

  /**
   * Identificador da coluna.
   * 
   * @param columnId - identificador da coluna.
   */
  public void setColumnId(String columnId) {
    this.columnId = columnId;
  }

  /**
   * Flag que indica se a coluna est visvel.
   * 
   * @return - true se a coluna estiver visvel, false caso contrrio.
   */
  public boolean isVisible() {
    return visible;
  }

  /**
   * Flag que indica se a coluna est visvel.
   * 
   * @param visible - true se a coluna estiver visvel, false caso contrrio.
   */
  public void setVisible(boolean visible) {
    this.visible = visible;
  }
}
