package csbase.client.remote.srvproxies.messageservice.consumers;

import tecgraf.javautils.core.filter.IFilter;
import csbase.util.messages.Message;

/**
 * Interface para a criao de estratgias de recebimento de mensagens.
 * 
 * @author Tecgraf
 */
public interface IMessageConsumer {
  /**
   * Atribui o ouvinte de mensagens deste adaptador. Caso j exista um, ele ser
   * substitudo.
   * 
   * @param listener Ouvinte que ir tratar as mensagens recebidas.
   * @param filter Filtro que determina quais mensagens sero consumidas
   */
  public void setListener(IListener listener, IFilter<Message> filter);

  /**
   * Remove o ouvinte de mensagens.
   */
  public void clearListener();

  /**
   * <p>
   * Ouvinte de mensagens recebidas pelo adaptador.
   * </p>
   * <p>
   * Utilizado para receber mensagens de forma assncrona.
   * </p>
   * 
   * @author Tecgraf
   */
  public interface IListener {
    /**
     * Trata mensagens recebidas.
     * 
     * @param messages Mensagens recebidas.
     */
    public void onMessagesReceived(Message... messages);

    /**
     * Trata exceo lanada ao (des)cadastrar o ouvinte e ao tentar obter
     * mensagens do servio de mensagens.
     * 
     * @param e exceo lanada ao tentar obter mensagens do servio de
     *        mensagens.
     */
    public void onExceptionThrown(Exception e);
  }
}
