/**
 * $Id$
 */
package csbase.client.util;

import java.awt.Window;
import java.util.List;
import java.util.Set;

import csbase.client.applications.projectsmanager.usersearch.UserDialog;
import csbase.client.applications.projectsmanager.usersearch.UserPanel;
import csbase.logic.UserOutline;

/**
 * Dilogo de escolha de permisses por usurio para shared object.
 * 
 * @author Tecgraf
 */
public class SharedObjectUserDialog extends UserDialog {

  /**
   * @param owner
   * @param allUsers
   * @param showPermissions
   * @param confirmation
   */
  public SharedObjectUserDialog(Window owner, List<UserOutline> allUsers,
    boolean showPermissions, boolean confirmation) {
    super(owner, allUsers, showPermissions, confirmation);
  }

  /**
   * @param owner
   * @param allUsers
   * @param usersRO
   * @param usersRW
   * @param showPermissions
   * @param confirmation
   */
  public SharedObjectUserDialog(Window owner, List<UserOutline> allUsers,
    Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions,
    boolean confirmation) {
    super(owner, allUsers, usersRO, usersRW, showPermissions, confirmation);
  }

  /**
   * @param owner
   * @param allUsers
   * @param usersRO
   * @param usersRW
   * @param showPermissions
   * @param confirmation
   * @param fixedAccess
   */
  public SharedObjectUserDialog(Window owner, List<UserOutline> allUsers,
    Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions,
    boolean confirmation, boolean fixedAccess) {
    super(owner, allUsers, usersRO, usersRW, showPermissions, confirmation,
      fixedAccess);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected UserPanel getUserPanel(List<UserOutline> allUsers,
    Set<Object> usersRO, final Set<Object> usersRW, boolean showPermissions,
    boolean fixedAccess) {
    return new SharedObjectUserPanel(allUsers, usersRO, usersRW,
      showPermissions, fixedAccess);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected UserPanel getUserPanel(List<UserOutline> allUsers,
    Set<Object> usersRO, final Set<Object> usersRW, boolean showPermissions) {
    return new SharedObjectUserPanel(allUsers, usersRO, usersRW,
      showPermissions);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected UserPanel getUserPanel(List<UserOutline> allUsers,
    boolean showPermissions) {
    return new SharedObjectUserPanel(allUsers, showPermissions);
  }

  /**
   * Retorna true se e somente se, o usurio escolheu leitura permitida para
   * todos os usurios
   * 
   * @return true se e somente se, o usurio escolheu leitura permitida para
   *         todos os usurios
   */
  public boolean isGlobal() {
    return ((SharedObjectUserPanel) userPanel).isGlobal();
  }

  /**
   * Atribui o valor de permisso para todos os usurios apropriadamente
   * 
   * @param isGlobal
   */
  public void setGlobal(boolean isGlobal) {
    ((SharedObjectUserPanel) userPanel).setGlobal(isGlobal);
  }
}
