/*
 * $Id: ComboPanel.java,v 1.1 2010/06/12 00:10:47 clinio Exp $
 */

package csbase.client.util.filechooser.fileparentcombopanel;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import csbase.client.ClientLocalFile;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;

/**
 * Painel de combobox com ancestrais de elemento selecionado.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ClientFileParentComboPanel extends JPanel {

  /**
   * Objeto do widget.
   */
  private ClientFile directory = null;

  /**
   * Combo
   */
  final private JComboBox combo = new JComboBox();

  /**
   * Listeners.
   */
  final private List<ClientFileParentComboChooseListener> listeners =
    new ArrayList<ClientFileParentComboChooseListener>();

  /**
   * Ajuste do objeto.
   *
   * @param directory o objeto
   */
  final public void setLeafDirectory(ClientFile directory) {
    if (!directory.canExecute() || !directory.canRead()) {
      return;
    }
    this.directory = directory;
    final List<ClientFile> ancestors = new ArrayList<ClientFile>();
    ClientFile elem = directory;
    while (elem != null) {
      ancestors.add(elem);
      elem = elem.getParent();
    }
    Collections.reverse(ancestors);

    if (directory.getClientFileType() == ClientFileType.LOCAL) {
      List<ClientLocalFile> roots =
        ClientFileChooserUtils.getLocalRootDirectories();
      for (ClientLocalFile root : roots) {
        if (!ancestors.contains(root)) {
          ancestors.add(root);
        }
      }
    }

    final int size = ancestors.size();
    if (size > 0) {
      final ClientFile[] array = ancestors.toArray(new ClientFile[size]);
      combo.setModel(new DefaultComboBoxModel(array));
      combo.setEnabled(true);
      combo.setSelectedItem(directory);
    }
    else {
      combo.setModel(new DefaultComboBoxModel());
      combo.setEnabled(false);
    }
  }

  /**
   * Obtm o objeto do widget.
   *
   * @return oobjeto.
   */
  public final ClientFile getDirectory() {
    return directory;
  }

  /**
   * Construtor
   */
  public ClientFileParentComboPanel() {
    setLayout(new BorderLayout());
    combo.setRenderer(new ClientFileParentComboRenderer());
    add(combo, BorderLayout.CENTER);
    addChooseListener();
  }

  /**
   * Adiciona listener de escolha.
   *
   * @param clientProjectFileParentComboChooseListener o listener
   */
  public void addParentsComboPanelChooseListener(
    final ClientFileParentComboChooseListener clientProjectFileParentComboChooseListener) {
    listeners.add(clientProjectFileParentComboChooseListener);
  }

  /**
   * Remove listener de escolha.
   *
   * @param listener o listener
   */
  public void delParentsComboPanelChooseListener(
    final ClientFileParentComboChooseListener listener) {
    listeners.remove(listener);
  }

  /**
   * Listener de escolha/
   */
  private void addChooseListener() {
    combo.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent e) {
        final ClientFile item = (ClientFile) combo.getSelectedItem();
        if (item == null || item.equals(directory)) {
          return;
        }
        for (ClientFileParentComboChooseListener l : listeners) {
          l.parentChosen(ClientFileParentComboPanel.this, item);
        }
      }
    });
  }
}
