package csbase.client;

/**
 * Classe que modela eventos relacionados  criao de ClientSmartFiles,
 * utilizados em ClientSmartFileListener.
 * 
 *
 * @author Tecgraf
 */
public class ClientSmartFileEvent {

  /**
   * Enumerao com causas possveis para falha no uso de otimizao de acesso 
   * rea de projetos
   * 
   * @author Tecgraf
   */
  public enum OptimizationFailCause {
    /**
     * Path para a rea local de projetos no  vlido. Pode no existir ou no
     * ser um diretrio.
     */
    PROJECT_PATH_NOT_VALID,
    /**
     * Local definido para rea de projetos no pode ser lido
     */
    CANT_READ_PROJECT_PATH,

    /**
     * Otimizao desabilitada por parmetro de execuo do Cliente
     */
    CLIENT_PARAMETER_VALUE,

    /**
     * Path para o arquivo "smart" no  vlido.
     */
    FILE_PATH_NOT_VALID,
    /**
     * O arquivo "smart" no pode ser lido.
     */
    CANT_READ_FILE
  }

  /**
   * Path Local do projeto
   */
  private String localProjectPath = null;

  /**
   * Path local do arquivo
   */
  private String fileLocalProjectPath = null;

  /**
   * Causa do evento
   */
  private OptimizationFailCause eventCause;

  /**
   * Indica se o evento se refere a um arquivo
   */
  private boolean fileEvent;

  /**
   * Construtor
   * 
   * @param localProjectPath Path Local do projeto
   * @param fileLocalProjectPath Path Local do arquivo
   * @param eventCause Causa do Evento
   */
  public ClientSmartFileEvent(String localProjectPath,
    String fileLocalProjectPath, OptimizationFailCause eventCause) {
    this.localProjectPath = localProjectPath;
    this.fileLocalProjectPath = fileLocalProjectPath;
    this.eventCause = eventCause;
    this.fileEvent = (fileLocalProjectPath != null);
  }

  /**
   * Construtor para eventos que no envolvem arquivos
   * 
   * @param localProjectPath Path Local do projeto
   * @param eventCause Causa do Evento
   */
  public ClientSmartFileEvent(String localProjectPath,
    OptimizationFailCause eventCause) {
    this.localProjectPath = localProjectPath;
    this.eventCause = eventCause;
    this.fileEvent = false;
  }

  /**
   * 
   * @return Caminho local do projeto
   */
  public String getLocalProjectPath() {
    return localProjectPath;
  }

  /**
   * 
   * @return Caminho local do arquivo
   */
  public String getFileLocalProjectPath() {
    return fileLocalProjectPath;
  }

  /**
   * 
   * @return Constante que representa a causa do evento
   */
  public OptimizationFailCause getEventCause() {
    return eventCause;
  }

  /**
   * 
   * @return true, se este evento fizer referncia a um arquivo
   */
  public boolean isFileEvent() {
    return fileEvent;
  }

}
