package csbase.client.applications.algorithmsmanager.report.core;

import java.awt.Window;
import java.util.List;

import tecgraf.javautils.gui.Task;

/**
 * Classe abstrata que itera sobre os dados do teste. As implementaes dos
 * testes s precisaram implementar a ao sobre um nico dado
 * 
 *
 * @author Tecgraf/PUC-Rio
 * @param <T> Tipo do dado sendo testado
 */
public abstract class AbstractTest<T> implements ITest<T> {

  /** Janela me da janela da task */
  private final Window taskParentWindow;
  /** Ttulo da task */
  private final String taskTitle;
  /** Mensagem da task */
  private final String taskMessage;

  /**
   * Consturtor
   * 
   * @param taskParentWindow Janela me da janela da task.
   * @param taskTitle Ttulo da task.
   * @param taskMessage Mensagem da task.
   */
  public AbstractTest(Window taskParentWindow, String taskTitle,
    String taskMessage) {
    super();
    this.taskParentWindow = taskParentWindow;
    this.taskTitle = taskTitle;
    this.taskMessage = taskMessage;
  }

  /** {@inheritDoc} */
  @Override
  public ITestResult<T> run(final Iterable<T> subjects) {

    Task<ITestResult<T>> task = new Task<ITestResult<T>>() {

      @Override
      protected void performTask() throws Exception {
        TestResult<T> result = new TestResult<>();
        for (T subject : subjects) {
          List<IResultMessage<T>> messages = doTest(subject);
          result.addMessages(messages);
        }
        setResult(result);
      }
    };

    task.execute(getTaskParentWindow(), getTaskTitle(), getTaskMessage());

    return task.getResult();
  }

  /**
   * Informa o nome da janela me da task
   * 
   * @return Janela
   */
  protected Window getTaskParentWindow() {
    return taskParentWindow;
  }

  /**
   * Informa o ttulo da task
   * 
   * @return Ttulo da task
   */
  protected String getTaskTitle() {
    return taskTitle;
  }

  /**
   * Informa a mensagem da
   * 
   * @return mensagem da task
   */
  protected String getTaskMessage() {
    return taskMessage;
  }

  /**
   * Aplica o teste a um assunto e retorna lista de mensagens
   * 
   * @param subject Dado a ser testado
   * @return lista de mensagens
   */
  protected abstract List<IResultMessage<T>> doTest(T subject);

}
