package csbase.client.applications.algorithmsmanager.report.core;

/**
 * Interface de um teste que analisa uma fonte itervel do tipo T. T pode ser um
 * algoritmo, um fluxo,um parmetro, etc.
 * 
 *
 * @author Tecgraf/PUC-Rio
 * @param <T> Assunto da anlise
 */
public interface ITest<T> {

  /**
   * Obtm o nome do teste
   * 
   * @return O nome do teste
   */
  public String getName();

  /**
   * Obtm a descrio do teste
   * 
   * @return A descrio do teste
   */
  public String getDescription();

  /**
   * Informa o nome do assunto. Assim pode-se usar um mtodo especfico do tipo
   * T em vez de simpesmente usar o toString()
   * 
   * @param subject
   * @return O nome do assunto
   */
  public String getSubjectName(T subject);

  /**
   * Roda o teste para uma fonte itervel
   * 
   * @param subjects Itervel dos objetos a serem analisados
   * @return Resultado
   */
  public ITestResult<T> run(Iterable<T> subjects);

  /**
   * Obtm a classe do T
   *
   * @return A classe do T
   */
  public Class<T> getSubjectClass();

}