/*
 * $Id:$
 */

package csbase.client.applications.diskmonitor.actions.core;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.diskmonitor.DiskMonitor;

/**
 * @author Tecgraf/PUC-Rio
 */
abstract public class DiskMonitorAction extends
  AbstractSimpleApplicationAction<DiskMonitor> {

  /**
   * Construtor padro.
   * 
   * @param application a aplicao que originou a ao.
   */
  public DiskMonitorAction(final DiskMonitor application) {
    super(application);
  }

  /**
   * Construtor.
   * 
   * @param application aplicao.
   * @param icon a imagem da ao.
   */
  protected DiskMonitorAction(final DiskMonitor application,
    final ImageIcon icon) {
    super(application, icon);
  }

  /**
   * Resultado da ao encapsulada do Java.
   * 
   * @param ae evento Java
   * @see #actionDone(JComponent)
   */
  @Override
  final public void handleActionPerformed(final ActionEvent ae) {
    try {
      final JComponent cmp = (ae == null ? null : (JComponent) ae.getSource());
      actionDone(cmp);
    }
    catch (Exception e) {
      final DiskMonitor application = getApplication();
      application.handleException(e);
    }
  }

  /**
   * Ao efeitiva a ser determinada pelas sub-classes
   * 
   * @param cmp componente
   * 
   * @throws Exception se houver falha na operao.
   */
  abstract public void actionDone(final JComponent cmp) throws Exception;
}
