/*
 * $Id: ConnectionFrame.java 116325 2011-03-18 03:17:58Z cassino $
 */

package csbase.client.applications.filetransferclient.dialogs;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;

import tecgraf.javautils.gui.ComboUtil;
import tecgraf.javautils.gui.GUIUtils;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.dialogs.core.FileTransferClientFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.logic.filetransferservice.FileTransferProtocol;

/**
 * Dilogo de conexo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ConnectionFrame extends FileTransferClientFrame {

  /**
   * Texto para nome do usurio
   */
  final private JTextField userText = new JTextField(25);

  /**
   * Texto para nome do servidor
   */
  final private JTextField serverText = new JTextField(25);

  /**
   * texto para senha.
   */
  final private JPasswordField passwdHiddenText = new JPasswordField(25);

  /**
   * Lista de protocolos.
   */
  final private JComboBox protocolList = new JComboBox();

  /**
   * {@inheritDoc}
   */
  @Override
  protected void frameStopped() {
    passwdHiddenText.setText(null);
  }

  /**
   * Mtodo que faz a conexo.
   */

  private void connect() {
    final FileTransferClient application = getApplication();

    final String serverName = serverText.getText();
    final String userName = userText.getText();

    @SuppressWarnings("deprecation")
    final String passwd = passwdHiddenText.getText();

    if (FileTransferClientUI.isEmptyString(userName)) {
      final String err = getString("no.user.error");
      application.showError(err);
      return;
    }

    if (FileTransferClientUI.isEmptyString(serverName)) {
      final String err = getString("no.server.error");
      application.showError(err);
      return;
    }

    if (FileTransferClientUI.isEmptyString(passwd)) {
      final String err = getString("no.password.error");
      application.showError(err);
      return;
    }

    final User loggedUser = User.getLoggedUser();
    final Object userId = loggedUser.getId();
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final CommonClientProject project = desktopFrame.getProject();
    final Object projectId = project.getId();
    final FileTransferProtocol protocol =
      (FileTransferProtocol) protocolList.getSelectedItem();
    final FileTransferConnection conn =
      new FileTransferConnection(protocol, serverName, userName, passwd,
        userId, projectId, null);

    final FileTransferProxy proxy = application.getServiceProxy();
    if (!proxy.checkConnection(conn)) {
      final String fmt = getString("connection.failure.error");
      final String err = String.format(fmt, userName, serverName);
      application.showError(err);
      application.setConnection(null);
      return;
    }
    application.setConnection(conn);
    stop();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final protected JPanel buildPanel(final FileTransferClient ftpClient) {
    final JPanel mainPanel = buildMainPanel(ftpClient);
    final JPanel buttonsPanel = buildButtonsPanel(ftpClient);

    final JPanel panel = new JPanel();
    panel.setLayout(new BorderLayout());

    panel.add(mainPanel, BorderLayout.CENTER);
    panel.add(buttonsPanel, BorderLayout.SOUTH);
    return panel;
  }

  /**
   * Monta o painel de botes.
   * 
   * @param ftpClient a aplicao.
   * @return o painel
   */
  private JPanel buildButtonsPanel(final FileTransferClient ftpClient) {
    final JButton closeButton = new JButton();
    closeButton.setText(getString("close.button"));
    closeButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ae) {
        stop();
      }
    });

    final JButton connButton = new JButton();
    connButton.setText(getString("connect.button"));
    connButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ae) {
        connect();
      }
    });

    final JComponent[] buttons = new JComponent[] { closeButton, connButton };
    GUIUtils.matchPreferredSizes(buttons);

    final JRootPane root = getRootPane();
    root.setDefaultButton(connButton);

    final JPanel panel = new JPanel();
    panel.setLayout(new FlowLayout(FlowLayout.CENTER));
    panel.add(connButton);
    panel.add(closeButton);
    return panel;
  }

  /**
   * Montagem do painel principal
   * 
   * @param app aplicao
   * @return o painel
   */
  private JPanel buildMainPanel(final FileTransferClient app) {
    final JLabel userLabel = new JLabel(getString("user.label"));
    final JLabel serverLabel = new JLabel(getString("server.label"));
    final JLabel passwdLabel = new JLabel(getString("password.label"));
    final JLabel protocolLabel = new JLabel(getString("protocol.label"));

    final JButton serverButton = new JButton();
    serverButton.setIcon(FileTransferClientUI.FAST_CONNECT_ICON);
    GUIUtils.trimImageButton(serverButton);
    serverButton.setToolTipText(getString("choose.server.tooltip"));
    serverButton.addActionListener(new ActionListener() {
      @Override
      final public void actionPerformed(ActionEvent ae) {
        choosePredefinedServer();
      }
    });

    final FileTransferProtocol[] protocols = FileTransferProtocol.values();
    final DefaultComboBoxModel model = new DefaultComboBoxModel(protocols);
    protocolList.setModel(model);
    protocolList.setSelectedItem(FileTransferProtocol.SFTP);

    final JComponent[][] cmps =
      new JComponent[][] { { serverLabel, serverText, serverButton },
          { protocolLabel, protocolList }, { userLabel, userText },
          { passwdLabel, passwdHiddenText } };

    final JPanel panel = GUIUtils.createBasicGridPanel(cmps);
    return panel;
  }

  /**
   * Escolha de um servidor predefinido.
   */
  private void choosePredefinedServer() {
    final FileTransferClient application = getApplication();
    final ApplicationFrame frame = application.getApplicationFrame();
    final String labelStr = getString("choose.server.label");
    final String title = getString("choose.server.title");
    final JComboBox combo = new JComboBox();
    final JLabel label = new JLabel(labelStr);
    final JComponent[][] cmps = new JComponent[][] { { label, combo } };
    final JPanel panel = GUIUtils.createBasicGridPanel(cmps);

    final List<FileTransferPredefinedConnection> predefs =
      application.getPredefinedConnections();
    final List<String> serversNames = new ArrayList<String>();
    for (FileTransferPredefinedConnection predef : predefs) {
      final String srvName = predef.getServerName();
      serversNames.add(srvName);
    }
    ComboUtil.updateFromList(combo, serversNames, 0);

    final int option =
      JOptionPane.showOptionDialog(frame, panel, title,
        JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE, null, null,
        null);
    if (option == JOptionPane.CANCEL_OPTION
      || option == JOptionPane.CLOSED_OPTION) {
      return;
    }
    final String selectedServerName = (String) combo.getSelectedItem();
    if (selectedServerName == null) {
      return;
    }
    serverText.setText(selectedServerName);
  }

  /**
   * Construtor.
   * 
   * @param application aplicao.
   */
  public ConnectionFrame(final FileTransferClient application) {
    super(application);
    setResizable(false);
  }

}
